import processing.core.*; 
import processing.xml.*; 

import java.awt.geom.*; 

import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.awt.event.*; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class finalsubmission extends PApplet {

//Jesse Campbell
//Computer Science - Senior Project - Rutgers University
//December 7th, 2009



boolean detectCollision, paused, avoidCollision, routing = true;
ArrayList vlist, console;
float[] tempspeed;
Road r;

public void setup(){
  size(600,400);
  vlist = new ArrayList();   
  vlist.add(new Vehicle(width*.1f, height*.1f, HALF_PI, random(20,50), 10, random(5), color(random())));
  vlist.add(new Vehicle(width*.1f, height*.9f, HALF_PI, 30, 10, random(5), color(random()))); 
  vlist.add(new Vehicle(width*.9f, height*.1f, HALF_PI, 30, 10, random(5), color(random()))); 
  vlist.add(new Vehicle(width*.9f, height*.9f, HALF_PI, 30, 10, random(5), color(random())));

  vlist.add(new Vehicle(width*.25f, height*.25f, PI, 20, 10, random(5), color(random())));
  vlist.add(new Vehicle(width*.25f, height*.75f, PI, 20, 10, random(5), color(random())));
  vlist.add(new Vehicle(width*.75f, height*.25f, PI, 20, 10, random(5), color(random())));
  vlist.add(new Vehicle(width*.75f, height*.75f, PI, 20, 10, random(5), color(random())));
  vlist.add(new Vehicle(width*.8f, height/2, PI, 20, 10, random(5), color(random())));  
  vlist.add(new Vehicle(width*.2f, height/2, PI, 20, 10, random(5), color(random())));
  
  if (t!=null) t.stop();
  r = new Road();
  new MovementThread();
  textAlign(CENTER); PFont myFont; myFont = loadFont("Tahoma-11.vlw");  textFont (myFont, 11);  textMode(SCREEN);
  
  paused = false;
  console = new ArrayList();
}

public void draw(){
  background(255);
 
  r.draw(); 
  for(int i=0; i<vlist.size(); i++) ((Vehicle)(vlist.get(i))).draw();

  gui();
}
  
public int random(){
  return color((int)random(255),(int)random(255),(int)random(255));
}
 
abstract class button{
  int unselected = color(125); int selected = color(0xffB20006); int txtcolor = color(255); 
  String textstring = "";
  float x, y, w, h;
  Rectangle rec;
}

class regbutton extends button{ 
  regbutton(String textstring, float x, float y, float w, float h){
  this.textstring = textstring; this.x = x; this.y = y; this.w = w; this.h = h;
  if (w < textstring.length()*6) this.w = textstring.length()*6;
  rec = new Rectangle(round(x-this.w/2),round(y-h/2),round(this.w),round(h));
  }
  
  public void draw(){
    rectMode(CENTER);
    fill(unselected);
    if (rec.contains(mouseX, mouseY))
      fill(selected);
    rect(x,y,w,h);
    fill(txtcolor);
    text(textstring,x,y);   
  }
}

class togglebutton extends button{
  boolean toggled = false;
  int toggledcolor = color(0xffBF7600);
  togglebutton(String textstring, float x, float y, float w, float h, boolean state){
  this.textstring = textstring; this.x = x; this.y = y; this.w = w; this.h = h; this.toggled = state;
  if (w < textstring.length()*6) this.w = textstring.length()*6;
  rec = new Rectangle(round(x-this.w/2),round(y-h/2),round(this.w),round(h));
  }
  
  public void draw(){
    rectMode(CENTER);
    fill(unselected);
    if (rec.contains(mouseX, mouseY))
      fill(selected);
    if (toggled)
      fill(toggledcolor);
    rect(x,y,w,h);
    fill(txtcolor);
    text(textstring,x,y);   
  }
}

togglebutton routingbtn = new togglebutton("Toggle Routing", 530, 250, 0, 20, routing);
togglebutton acbtn = new togglebutton("Avoid Collisions", 530, 325, 0, 20, avoidCollision);
togglebutton dcbtn = new togglebutton("Detect Collisions", 530, 350, 0, 20, detectCollision);
togglebutton pausebtn = new togglebutton(" Pause ", 505, 375, 0, 20, paused);
regbutton addcarsbtn = new regbutton(" Add Car", 530, 275, 0, 20);
regbutton removecarsbtn = new regbutton(" Remove Car", 530, 300, 0, 20);
regbutton resetbtn = new regbutton(" Reset ", 555, 375, 0, 20);

public void gui(){
  //Console start
  rectMode(CENTER);
  fill(0,175);
  rect(540, height/2, 150, height);
  fill(0xff30553D,200);
  rect(200, 370, 535, 60);
  fill(255);

  textAlign(LEFT);
  for(int i=0; i < console.size(); i++)
    if (i < 3) text((String)(console.get(console.size()-1-i)), 10, 360 + i*15);
  textAlign(CENTER);
  //Console end

  fill(255);
  textAlign(CENTER, CENTER); //PFont myFont; myFont = loadFont("Tahoma-11.vlw"); textFont (myFont, 11); textMode(SCREEN);
  text("Autonomous\n Vehicle\n Simulation", 535, 40);
  text("Vehicles: " + vlist.size(), 535 , 110);
  text("Framerate: " + round(frameRate), 535 , 125);
  text("Mouse: " + mouseX + "x" + " " + mouseY + "y", 535, 95);
  text("Jesse Campbell\n jcamp@gmx.com", 535, 175);


acbtn.draw();
dcbtn.draw();
resetbtn.draw();
addcarsbtn.draw();
removecarsbtn.draw();
pausebtn.draw();
routingbtn.draw();
}

public void mouseClicked(){
  if (acbtn.rec.contains(mouseX, mouseY)){
    acbtn.toggled = !acbtn.toggled;
    avoidCollision = !avoidCollision;
  }
  
  if (dcbtn.rec.contains(mouseX, mouseY)){
    dcbtn.toggled = !dcbtn.toggled;
    detectCollision = !detectCollision;
  }
  
  if (addcarsbtn.rec.contains(mouseX, mouseY)){ 
    addsafe(1);
    }
  
  if (removecarsbtn.rec.contains(mouseX, mouseY)){
    if (vlist.size() > 0)
    vlist.remove(vlist.size()-1);
    }
  
  if (pausebtn.rec.contains(mouseX,mouseY)){
    if (!paused){
      tempspeed = new float[vlist.size()];
      for(int i=0; i<vlist.size(); i++){
        tempspeed[i] = ((Vehicle)(vlist.get(i))).speed;
          ((Vehicle)(vlist.get(i))).speed = 0;
      }
    }
    if (paused){
      for(int i=0; i< tempspeed.length; i++){
        if (i < vlist.size())
        ((Vehicle)(vlist.get(i))).speed = tempspeed[i];
      }
    }
  paused = !paused;
  pausebtn.toggled = !pausebtn.toggled;
  }
  
  if (resetbtn.rec.contains(mouseX,mouseY)){
    setup();
    paused = false;
    pausebtn.toggled = false;
  }
  
  if (routingbtn.rec.contains(mouseX, mouseY)){
    routing = !routing;
    routingbtn.toggled = !routingbtn.toggled;
  }
}

public void addsafe(int count){
    int tempcount = 0;
    tempcount += count;
    int tempx = (int)random(1,width-1);
    int tempy = (int)random(1,height-1);
    boolean clear = true;
    for (int i=0; i < vlist.size(); i++)
       if (  dist (tempx, tempy, ((Vehicle)vlist.get(i)).x, ((Vehicle)vlist.get(i)).y) < 50) clear = false;
    if (clear)
      vlist.add(new Vehicle(tempx, tempy, random(TWO_PI), 20, 10, random(5), color(random()) ));
    else
      if (tempcount < 10)
        addsafe(tempcount);
    }
Thread t;
class MovementThread implements Runnable {
  MovementThread() {
    t = new Thread(this,"Movement Thread");
    t.start(); 
  }

  public void run() {
    try { 
      while(true)
      {
        for (int i=0; i < vlist.size(); i++)
          for (int j=0; j <((Vehicle)vlist.get(i)).speed; j++){
            if(routing)
              ((Vehicle)vlist.get(i)).route();
            ((Vehicle)vlist.get(i)).move();
             if(detectCollision)
                ((Vehicle)(vlist.get(i))).dc();
             if (avoidCollision)
              ((Vehicle)(vlist.get(i))).ac();
          }
        Thread.sleep((long)(1/frameRate*1000)); //Update position once per frame to limit CPU usage
      }
    } 
    catch (InterruptedException e) {
      System.out.println("Child interrupted.");
    }
    System.out.println("Exiting child thread.");
  }
}
class Road{
  ArrayList road;
  ArrayList lane;
  ArrayList lane2;

  Road(){
    road = new ArrayList();
    lane = new ArrayList();
    lane2 = new ArrayList();

    road.add(lane);
    road.add(lane2);

    lane.add(new Point2D.Float(width/4,height/4));
    lane.add(new Point2D.Float(width*.75f,height/4));
    lane.add(new Point2D.Float(width*.8f, height/2));
    lane.add(new Point2D.Float(width*.75f,height*.75f));
    lane.add(new Point2D.Float(width*.25f,height*.75f));
    lane.add(new Point2D.Float(width*.2f, height/2));


    lane2.add(new Point2D.Float(width*.10f,height*.10f));
    lane2.add(new Point2D.Float(width*.9f,height*.10f));
    lane2.add(new Point2D.Float(width*.9f,height*.9f));
    lane2.add(new Point2D.Float(width*.1f,height*.9f));
}

  public void draw(){
    for (int i=0; i<lane.size(); i++)
      line((float)((Point2D)(lane.get(i))).getX(),
      (float)((Point2D)(lane.get(i))).getY(),
      (float)((Point2D)(lane.get((i+1) % lane.size() ))).getX(),
      (float)((Point2D)(lane.get((i+1) % lane.size() ))).getY());

    for (int i=0; i<lane2.size(); i++)
      line((float)((Point2D)(lane2.get(i))).getX(),
      (float)((Point2D)(lane2.get(i))).getY(),
      (float)((Point2D)(lane2.get((i+1) % lane2.size() ))).getX(),
      (float)((Point2D)(lane2.get((i+1) % lane2.size() ))).getY());
  }
}

class Vehicle{
  float x,y,theta,w,l,speed; int c; 
  int vertices, sensor_vertices; int[] x_before, y_before, x_after, y_after, xs_before, ys_before, xs_after, ys_after;
  Polygon p_after, s_after; Rectangle bounds, sbounds; PMatrix2D matrix; Point2D[] pastpath; ArrayList futurepath;

  Vehicle(float x,float y, float theta, float w, float l, float speed, int c){ 
    this.x = x; this.y = y; this.theta = theta; this.w = w; this.l = l; this.speed = speed; this.c = c;

    vertices = 4; x_before = new int[vertices]; y_before = new int[vertices]; x_after = new int[vertices]; y_after = new int[vertices];
    x_before[0] = (int)w/2; x_before[1] = -(int)w/2; x_before[2] = -(int)w/2; x_before[3] = (int)w/2;
    y_before[0] = (int)l/2; y_before[1] = (int)l/2; y_before[2] = -(int)l/2; y_before[3] = -(int)l/2;

    p_after = new Polygon(); bounds = new Rectangle(); sbounds = new Rectangle();
    matrix = new PMatrix2D(); pastpath = new Point2D.Float[2]; futurepath = new ArrayList(); pastpath[0] = new Point2D.Float(x,y);

    sensor_vertices = 8; xs_before = new int[sensor_vertices]; ys_before = new int[sensor_vertices]; xs_after = new int[sensor_vertices]; ys_after = new int[sensor_vertices];   
    xs_before[0] = (int)(w);   ys_before[0] = (int)0;    xs_before[1] = (int)(-w);  ys_before[1] = (int)0; 
    xs_before[2] = (int)0;     ys_before[2] = (int)l;    xs_before[3] = (int)0;     ys_before[3] = (int)-l;
    xs_before[4] = (int)w;     ys_before[4] = (int)l;    xs_before[5] = (int)-w;    ys_before[5] = (int)l;
    xs_before[6] = (int)w;     ys_before[6] = (int)-l;   xs_before[7] = (int)-w;    ys_before[7] = (int)-l;
  }

  public void draw(){
    pushMatrix(); translate(x,y); rotate(theta); matrix = getMatrix(matrix); popMatrix();

    for (int i=0; i<vertices; i++){
      x_after[i] = (int)(matrix.multX(x_before[i],y_before[i])); y_after[i] = (int)(matrix.multY(x_before[i],y_before[i]));
    }

    p_after = new Polygon(x_after,y_after,vertices); bounds = p_after.getBounds();
    fill(c); beginShape(); for(int i=0; i<vertices; i++) vertex(x_after[i],y_after[i]); endShape(CLOSE);
   
    for(int i=0; i<sensor_vertices; i++){
      xs_after[i] = (int)(matrix.multX(xs_before[i],ys_before[i])); ys_after[i] = (int)(matrix.multY(xs_before[i],ys_before[i]));
    }
    
   s_after = new Polygon(xs_after,ys_after,sensor_vertices); sbounds = s_after.getBounds();
   
  for(int i=0; i < sensor_vertices; i++) ellipse(matrix.multX(xs_before[i], ys_before[i]), matrix.multY(xs_before[i], ys_before[i]), 3, 3);
  }

  public void move(){
    x+=cos(theta); y+=sin(theta);

    if ((int)y == 0 || (int)y == height) theta=-theta;
    if ((int)x == 0 || (int)x == width ) theta=PI-theta;

    theta%=TWO_PI;

    if(random(20) < 1){
      pastpath[1] = pastpath[0]; pastpath[0] = new Point2D.Float(x, y);
    }

    if (futurepath.size() != 0) turn((Point2D) futurepath.get(0));

    if (futurepath.size() != 0) 
      if ( (int) dist(x,y,(float)((Point2D)(futurepath.get(0))).getX(), (float)((Point2D)(futurepath.get(0))).getY()) == 0)     
        futurepath.remove(0);     
  } 

  public void spline(Point2D dest, Point2D afterdest){ 
   // if (futurepath.size() == 0){
      Point2D[] p,q; p = new Point2D[5]; float t=0;
      p[1] = pastpath[0]; p[2] = new Point2D.Float(x,y); p[3] = dest; p[4] = afterdest;
      int points = (int)(dist((float)p[2].getX(), (float)p[2].getY(), (float)p[3].getX(), (float)p[3].getY()))/5;
      q = new Point2D[points];

      for(int i=0; i<points; i++){
        t+=1/((float)(points)); q[i] = new Point2D.Float(); q[i].setLocation(
            0.5f *((-p[1].getX() + 3*p[2].getX() -3*p[3].getX() + p[4].getX())*t*t*t
          + (2*p[1].getX() -5*p[2].getX() + 4*p[3].getX() - p[4].getX())*t*t + (-p[1].getX()+p[3].getX())*t
          + 2*p[2].getX()), 0.5f * ((-p[1].getY() + 3*p[2].getY() -3*p[3].getY() + p[4].getY())*t*t*t
          + (2*p[1].getY() -5*p[2].getY() + 4*p[3].getY() - p[4].getY())*t*t + (-p[1].getY()+p[3].getY())*t
          + 2*p[2].getY()));

        point((float)q[i].getX(),(float)q[i].getY()); futurepath.add(q[i]);
      }
      futurepath.add(dest); futurepath.add(afterdest);
    //}
  }

  public void turn(Point2D dest){
    PVector v1 = new PVector( (float)dest.getX() - x, (float)dest.getY() - y); PVector v2 = new PVector( 1, 0); 
    if (dest.getY() > y) theta = +PVector.angleBetween(v1, v2);
    else theta = -PVector.angleBetween(v1, v2);
  }

  public void ac(){ //collision avoidance 
    Vehicle a = this, b;
    for (int i=0; i<vlist.size(); i++){
      b = (Vehicle)vlist.get(i);
      if (a != b)
        if ((b.sbounds).intersects(a.sbounds))
            if (a.s_after.contains(b.xs_after[0],b.ys_after[0])){
              a.speed = b.speed;
              b.speed = a.speed;
            }
        if ((a.sbounds).intersects(b.sbounds))
            if (b.s_after.contains(a.xs_after[1],a.ys_after[1])){
              a.speed = b.speed;
              b.speed = a.speed;
            }

    }
  }

  public void network(){}

  public void route(){
    for (int i=0; i<r.lane.size(); i++){
      if ( (int) (dist(x,y, (float)((Point2D)(r.lane.get(i))).getX(), (float)((Point2D)(r.lane.get(i))).getY())) == 0)
        turn((Point2D)(r.lane.get( (i+1) % r.lane.size())));
    }

    for (int i=0; i<r.lane2.size(); i++){
      if ( (int) (dist(x,y, (float)((Point2D)(r.lane2.get(i))).getX(), (float)((Point2D)(r.lane2.get(i))).getY())) == 0)
        turn((Point2D)(r.lane2.get( (i+1) % r.lane2.size())));
        //spline( (Point2D)(r.lane.get( (i+1) % r.lane.size() )), (Point2D)(r.lane.get( (i+2) % r.lane.size() )) );  
    }
  }

  public void dc(){ //collision detection
    Vehicle a = this, b;
    for (int i=0; i<vlist.size(); i++){
      b = (Vehicle)vlist.get(i);
      if (a != b)
        if ((b.bounds).intersects(a.bounds))
          for (int j=0; j<a.vertices; j++)
            if (a.p_after.contains(b.x_after[j],b.y_after[j])){
              a.speed = b.speed = 0;
              console.add(new String(millis()+ " s " + a.hashCode() + " has collided with " + b.hashCode()));  
            }
    }
  }
}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#D4D0C8", "finalsubmission" });
  }
}
