 
abstract class button{
  color unselected = color(125); color selected = color(#B20006); color txtcolor = color(255); 
  String textstring = "";
  float x, y, w, h;
  Rectangle rec;
}

class regbutton extends button{ 
  regbutton(String textstring, float x, float y, float w, float h){
  this.textstring = textstring; this.x = x; this.y = y; this.w = w; this.h = h;
  if (w < textstring.length()*6) this.w = textstring.length()*6;
  rec = new Rectangle(round(x-this.w/2),round(y-h/2),round(this.w),round(h));
  }
  
  void draw(){
    rectMode(CENTER);
    fill(unselected);
    if (rec.contains(mouseX, mouseY))
      fill(selected);
    rect(x,y,w,h);
    fill(txtcolor);
    text(textstring,x,y);   
  }
}

class togglebutton extends button{
  boolean toggled = false;
  color toggledcolor = color(#BF7600);
  togglebutton(String textstring, float x, float y, float w, float h, boolean state){
  this.textstring = textstring; this.x = x; this.y = y; this.w = w; this.h = h; this.toggled = state;
  if (w < textstring.length()*6) this.w = textstring.length()*6;
  rec = new Rectangle(round(x-this.w/2),round(y-h/2),round(this.w),round(h));
  }
  
  void draw(){
    rectMode(CENTER);
    fill(unselected);
    if (rec.contains(mouseX, mouseY))
      fill(selected);
    if (toggled)
      fill(toggledcolor);
    rect(x,y,w,h);
    fill(txtcolor);
    text(textstring,x,y);   
  }
}

togglebutton routingbtn = new togglebutton("Toggle Routing", 530, 250, 0, 20, routing);
togglebutton acbtn = new togglebutton("Avoid Collisions", 530, 325, 0, 20, avoidCollision);
togglebutton dcbtn = new togglebutton("Detect Collisions", 530, 350, 0, 20, detectCollision);
togglebutton pausebtn = new togglebutton(" Pause ", 505, 375, 0, 20, paused);
regbutton addcarsbtn = new regbutton(" Add Car", 530, 275, 0, 20);
regbutton removecarsbtn = new regbutton(" Remove Car", 530, 300, 0, 20);
regbutton resetbtn = new regbutton(" Reset ", 555, 375, 0, 20);

void gui(){
  //Console start
  rectMode(CENTER);
  fill(0,175);
  rect(540, height/2, 150, height);
  fill(#30553D,200);
  rect(200, 370, 535, 60);
  fill(255);

  textAlign(LEFT);
  for(int i=0; i < console.size(); i++)
    if (i < 3) text((String)(console.get(console.size()-1-i)), 10, 360 + i*15);
  textAlign(CENTER);
  //Console end

  fill(255);
  textAlign(CENTER, CENTER); //PFont myFont; myFont = loadFont("Tahoma-11.vlw"); textFont (myFont, 11); textMode(SCREEN);
  text("Autonomous\n Vehicle\n Simulation", 535, 40);
  text("Vehicles: " + vlist.size(), 535 , 110);
  text("Framerate: " + round(frameRate), 535 , 125);
  text("Mouse: " + mouseX + "x" + " " + mouseY + "y", 535, 95);
  text("Jesse Campbell\n jcamp@gmx.com", 535, 175);


acbtn.draw();
dcbtn.draw();
resetbtn.draw();
addcarsbtn.draw();
removecarsbtn.draw();
pausebtn.draw();
routingbtn.draw();
}

void mouseClicked(){
  if (acbtn.rec.contains(mouseX, mouseY)){
    acbtn.toggled = !acbtn.toggled;
    avoidCollision = !avoidCollision;
  }
  
  if (dcbtn.rec.contains(mouseX, mouseY)){
    dcbtn.toggled = !dcbtn.toggled;
    detectCollision = !detectCollision;
  }
  
  if (addcarsbtn.rec.contains(mouseX, mouseY)){ 
    addsafe(1);
    }
  
  if (removecarsbtn.rec.contains(mouseX, mouseY)){
    if (vlist.size() > 0)
    vlist.remove(vlist.size()-1);
    }
  
  if (pausebtn.rec.contains(mouseX,mouseY)){
    if (!paused){
      tempspeed = new float[vlist.size()];
      for(int i=0; i<vlist.size(); i++){
        tempspeed[i] = ((Vehicle)(vlist.get(i))).speed;
          ((Vehicle)(vlist.get(i))).speed = 0;
      }
    }
    if (paused){
      for(int i=0; i< tempspeed.length; i++){
        if (i < vlist.size())
        ((Vehicle)(vlist.get(i))).speed = tempspeed[i];
      }
    }
  paused = !paused;
  pausebtn.toggled = !pausebtn.toggled;
  }
  
  if (resetbtn.rec.contains(mouseX,mouseY)){
    setup();
    paused = false;
    pausebtn.toggled = false;
  }
  
  if (routingbtn.rec.contains(mouseX, mouseY)){
    routing = !routing;
    routingbtn.toggled = !routingbtn.toggled;
  }
}

void addsafe(int count){
    int tempcount = 0;
    tempcount += count;
    int tempx = (int)random(1,width-1);
    int tempy = (int)random(1,height-1);
    boolean clear = true;
    for (int i=0; i < vlist.size(); i++)
       if (  dist (tempx, tempy, ((Vehicle)vlist.get(i)).x, ((Vehicle)vlist.get(i)).y) < 50) clear = false;
    if (clear)
      vlist.add(new Vehicle(tempx, tempy, random(TWO_PI), 20, 10, random(5), color(random()) ));
    else
      if (tempcount < 10)
        addsafe(tempcount);
    }
