class Vehicle{
  float x,y,theta,w,l,speed; color c; 
  int vertices, sensor_vertices; int[] x_before, y_before, x_after, y_after, xs_before, ys_before, xs_after, ys_after;
  Polygon p_after, s_after; Rectangle bounds, sbounds; PMatrix2D matrix; Point2D[] pastpath; ArrayList futurepath;

  Vehicle(float x,float y, float theta, float w, float l, float speed, color c){ 
    this.x = x; this.y = y; this.theta = theta; this.w = w; this.l = l; this.speed = speed; this.c = c;

    vertices = 4; x_before = new int[vertices]; y_before = new int[vertices]; x_after = new int[vertices]; y_after = new int[vertices];
    x_before[0] = (int)w/2; x_before[1] = -(int)w/2; x_before[2] = -(int)w/2; x_before[3] = (int)w/2;
    y_before[0] = (int)l/2; y_before[1] = (int)l/2; y_before[2] = -(int)l/2; y_before[3] = -(int)l/2;

    p_after = new Polygon(); bounds = new Rectangle(); sbounds = new Rectangle();
    matrix = new PMatrix2D(); pastpath = new Point2D.Float[2]; futurepath = new ArrayList(); pastpath[0] = new Point2D.Float(x,y);

    sensor_vertices = 8; xs_before = new int[sensor_vertices]; ys_before = new int[sensor_vertices]; xs_after = new int[sensor_vertices]; ys_after = new int[sensor_vertices];   
    xs_before[0] = (int)(w);   ys_before[0] = (int)0;    xs_before[1] = (int)(-w);  ys_before[1] = (int)0; 
    xs_before[2] = (int)0;     ys_before[2] = (int)l;    xs_before[3] = (int)0;     ys_before[3] = (int)-l;
    xs_before[4] = (int)w;     ys_before[4] = (int)l;    xs_before[5] = (int)-w;    ys_before[5] = (int)l;
    xs_before[6] = (int)w;     ys_before[6] = (int)-l;   xs_before[7] = (int)-w;    ys_before[7] = (int)-l;
  }

  void draw(){
    pushMatrix(); translate(x,y); rotate(theta); matrix = getMatrix(matrix); popMatrix();

    for (int i=0; i<vertices; i++){
      x_after[i] = (int)(matrix.multX(x_before[i],y_before[i])); y_after[i] = (int)(matrix.multY(x_before[i],y_before[i]));
    }

    p_after = new Polygon(x_after,y_after,vertices); bounds = p_after.getBounds();
    fill(c); beginShape(); for(int i=0; i<vertices; i++) vertex(x_after[i],y_after[i]); endShape(CLOSE);
   
    for(int i=0; i<sensor_vertices; i++){
      xs_after[i] = (int)(matrix.multX(xs_before[i],ys_before[i])); ys_after[i] = (int)(matrix.multY(xs_before[i],ys_before[i]));
    }
    
   s_after = new Polygon(xs_after,ys_after,sensor_vertices); sbounds = s_after.getBounds();
   
  for(int i=0; i < sensor_vertices; i++) ellipse(matrix.multX(xs_before[i], ys_before[i]), matrix.multY(xs_before[i], ys_before[i]), 3, 3);
  }

  void move(){
    x+=cos(theta); y+=sin(theta);

    if ((int)y == 0 || (int)y == height) theta=-theta;
    if ((int)x == 0 || (int)x == width ) theta=PI-theta;

    theta%=TWO_PI;

    if(random(20) < 1){
      pastpath[1] = pastpath[0]; pastpath[0] = new Point2D.Float(x, y);
    }

    if (futurepath.size() != 0) turn((Point2D) futurepath.get(0));

    if (futurepath.size() != 0) 
      if ( (int) dist(x,y,(float)((Point2D)(futurepath.get(0))).getX(), (float)((Point2D)(futurepath.get(0))).getY()) == 0)     
        futurepath.remove(0);     
  } 

  void spline(Point2D dest, Point2D afterdest){ 
   // if (futurepath.size() == 0){
      Point2D[] p,q; p = new Point2D[5]; float t=0;
      p[1] = pastpath[0]; p[2] = new Point2D.Float(x,y); p[3] = dest; p[4] = afterdest;
      int points = (int)(dist((float)p[2].getX(), (float)p[2].getY(), (float)p[3].getX(), (float)p[3].getY()))/5;
      q = new Point2D[points];

      for(int i=0; i<points; i++){
        t+=1/((float)(points)); q[i] = new Point2D.Float(); q[i].setLocation(
            0.5 *((-p[1].getX() + 3*p[2].getX() -3*p[3].getX() + p[4].getX())*t*t*t
          + (2*p[1].getX() -5*p[2].getX() + 4*p[3].getX() - p[4].getX())*t*t + (-p[1].getX()+p[3].getX())*t
          + 2*p[2].getX()), 0.5 * ((-p[1].getY() + 3*p[2].getY() -3*p[3].getY() + p[4].getY())*t*t*t
          + (2*p[1].getY() -5*p[2].getY() + 4*p[3].getY() - p[4].getY())*t*t + (-p[1].getY()+p[3].getY())*t
          + 2*p[2].getY()));

        point((float)q[i].getX(),(float)q[i].getY()); futurepath.add(q[i]);
      }
      futurepath.add(dest); futurepath.add(afterdest);
    //}
  }

  void turn(Point2D dest){
    PVector v1 = new PVector( (float)dest.getX() - x, (float)dest.getY() - y); PVector v2 = new PVector( 1, 0); 
    if (dest.getY() > y) theta = +PVector.angleBetween(v1, v2);
    else theta = -PVector.angleBetween(v1, v2);
  }

  void ac(){ //collision avoidance 
    Vehicle a = this, b;
    for (int i=0; i<vlist.size(); i++){
      b = (Vehicle)vlist.get(i);
      if (a != b)
        if ((b.sbounds).intersects(a.sbounds))
            if (a.s_after.contains(b.xs_after[0],b.ys_after[0])){
              a.speed = b.speed;
              b.speed = a.speed;
            }
        if ((a.sbounds).intersects(b.sbounds))
            if (b.s_after.contains(a.xs_after[1],a.ys_after[1])){
              a.speed = b.speed;
              b.speed = a.speed;
            }

    }
  }

  void network(){}

  void route(){
    for (int i=0; i<r.lane.size(); i++){
      if ( (int) (dist(x,y, (float)((Point2D)(r.lane.get(i))).getX(), (float)((Point2D)(r.lane.get(i))).getY())) == 0)
        turn((Point2D)(r.lane.get( (i+1) % r.lane.size())));
    }

    for (int i=0; i<r.lane2.size(); i++){
      if ( (int) (dist(x,y, (float)((Point2D)(r.lane2.get(i))).getX(), (float)((Point2D)(r.lane2.get(i))).getY())) == 0)
        turn((Point2D)(r.lane2.get( (i+1) % r.lane2.size())));
        //spline( (Point2D)(r.lane.get( (i+1) % r.lane.size() )), (Point2D)(r.lane.get( (i+2) % r.lane.size() )) );  
    }
  }

  void dc(){ //collision detection
    Vehicle a = this, b;
    for (int i=0; i<vlist.size(); i++){
      b = (Vehicle)vlist.get(i);
      if (a != b)
        if ((b.bounds).intersects(a.bounds))
          for (int j=0; j<a.vertices; j++)
            if (a.p_after.contains(b.x_after[j],b.y_after[j])){
              a.speed = b.speed = 0;
              console.add(new String(millis()+ " s " + a.hashCode() + " has collided with " + b.hashCode()));  
            }
    }
  }
}
