/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PMatrix2D;
import processing.core.PVector;

public class finalsubmission
extends PApplet {
    boolean detectCollision;
    boolean paused;
    boolean avoidCollision;
    boolean routing = true;
    ArrayList vlist;
    ArrayList console;
    float[] tempspeed;
    Road r;
    togglebutton routingbtn = new togglebutton("Toggle Routing", 530.0f, 250.0f, 0.0f, 20.0f, this.routing);
    togglebutton acbtn = new togglebutton("Avoid Collisions", 530.0f, 325.0f, 0.0f, 20.0f, this.avoidCollision);
    togglebutton dcbtn = new togglebutton("Detect Collisions", 530.0f, 350.0f, 0.0f, 20.0f, this.detectCollision);
    togglebutton pausebtn = new togglebutton(" Pause ", 505.0f, 375.0f, 0.0f, 20.0f, this.paused);
    regbutton addcarsbtn = new regbutton(" Add Car", 530.0f, 275.0f, 0.0f, 20.0f);
    regbutton removecarsbtn = new regbutton(" Remove Car", 530.0f, 300.0f, 0.0f, 20.0f);
    regbutton resetbtn = new regbutton(" Reset ", 555.0f, 375.0f, 0.0f, 20.0f);
    Thread t;

    public void setup() {
        this.size(600, 400);
        this.vlist = new ArrayList();
        this.vlist.add(new Vehicle((float)this.width * 0.1f, (float)this.height * 0.1f, 1.5707964f, this.random(20.0f, 50.0f), 10.0f, this.random(5.0f), this.color(this.random())));
        this.vlist.add(new Vehicle((float)this.width * 0.1f, (float)this.height * 0.9f, 1.5707964f, 30.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        this.vlist.add(new Vehicle((float)this.width * 0.9f, (float)this.height * 0.1f, 1.5707964f, 30.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        this.vlist.add(new Vehicle((float)this.width * 0.9f, (float)this.height * 0.9f, 1.5707964f, 30.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        this.vlist.add(new Vehicle((float)this.width * 0.25f, (float)this.height * 0.25f, (float)Math.PI, 20.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        this.vlist.add(new Vehicle((float)this.width * 0.25f, (float)this.height * 0.75f, (float)Math.PI, 20.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        this.vlist.add(new Vehicle((float)this.width * 0.75f, (float)this.height * 0.25f, (float)Math.PI, 20.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        this.vlist.add(new Vehicle((float)this.width * 0.75f, (float)this.height * 0.75f, (float)Math.PI, 20.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        this.vlist.add(new Vehicle((float)this.width * 0.8f, this.height / 2, (float)Math.PI, 20.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        this.vlist.add(new Vehicle((float)this.width * 0.2f, this.height / 2, (float)Math.PI, 20.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        if (this.t != null) {
            this.t.stop();
        }
        this.r = new Road();
        new MovementThread();
        this.textAlign(3);
        PFont pFont = this.loadFont("Tahoma-11.vlw");
        this.textFont(pFont, 11.0f);
        this.textMode(256);
        this.paused = false;
        this.console = new ArrayList();
    }

    public void draw() {
        this.background(255);
        this.r.draw();
        int n = 0;
        while (n < this.vlist.size()) {
            ((Vehicle)this.vlist.get(n)).draw();
            ++n;
        }
        this.gui();
    }

    public int random() {
        return this.color((int)this.random(255.0f), (int)this.random(255.0f), (int)this.random(255.0f));
    }

    public void gui() {
        this.rectMode(3);
        this.fill(0, 175.0f);
        this.rect(540.0f, this.height / 2, 150.0f, this.height);
        this.fill(-13609667, 200.0f);
        this.rect(200.0f, 370.0f, 535.0f, 60.0f);
        this.fill(255);
        this.textAlign(37);
        int n = 0;
        while (n < this.console.size()) {
            if (n < 3) {
                this.text((String)this.console.get(this.console.size() - 1 - n), 10.0f, (float)(360 + n * 15));
            }
            ++n;
        }
        this.textAlign(3);
        this.fill(255);
        this.textAlign(3, 3);
        this.text("Autonomous\n Vehicle\n Simulation", 535.0f, 40.0f);
        this.text("Vehicles: " + this.vlist.size(), 535.0f, 110.0f);
        this.text("Framerate: " + finalsubmission.round(this.frameRate), 535.0f, 125.0f);
        this.text("Mouse: " + this.mouseX + "x" + " " + this.mouseY + "y", 535.0f, 95.0f);
        this.text("Jesse Campbell\n jcamp@gmx.com", 535.0f, 175.0f);
        this.acbtn.draw();
        this.dcbtn.draw();
        this.resetbtn.draw();
        this.addcarsbtn.draw();
        this.removecarsbtn.draw();
        this.pausebtn.draw();
        this.routingbtn.draw();
    }

    public void mouseClicked() {
        if (this.acbtn.rec.contains(this.mouseX, this.mouseY)) {
            this.acbtn.toggled = !this.acbtn.toggled;
            boolean bl = this.avoidCollision = !this.avoidCollision;
        }
        if (this.dcbtn.rec.contains(this.mouseX, this.mouseY)) {
            this.dcbtn.toggled = !this.dcbtn.toggled;
            boolean bl = this.detectCollision = !this.detectCollision;
        }
        if (this.addcarsbtn.rec.contains(this.mouseX, this.mouseY)) {
            this.addsafe(1);
        }
        if (this.removecarsbtn.rec.contains(this.mouseX, this.mouseY) && this.vlist.size() > 0) {
            this.vlist.remove(this.vlist.size() - 1);
        }
        if (this.pausebtn.rec.contains(this.mouseX, this.mouseY)) {
            int n;
            if (!this.paused) {
                this.tempspeed = new float[this.vlist.size()];
                n = 0;
                while (n < this.vlist.size()) {
                    this.tempspeed[n] = ((Vehicle)this.vlist.get((int)n)).speed;
                    ((Vehicle)this.vlist.get((int)n)).speed = 0.0f;
                    ++n;
                }
            }
            if (this.paused) {
                n = 0;
                while (n < this.tempspeed.length) {
                    if (n < this.vlist.size()) {
                        ((Vehicle)this.vlist.get((int)n)).speed = this.tempspeed[n];
                    }
                    ++n;
                }
            }
            this.paused = !this.paused;
            boolean bl = this.pausebtn.toggled = !this.pausebtn.toggled;
        }
        if (this.resetbtn.rec.contains(this.mouseX, this.mouseY)) {
            this.setup();
            this.paused = false;
            this.pausebtn.toggled = false;
        }
        if (this.routingbtn.rec.contains(this.mouseX, this.mouseY)) {
            this.routing = !this.routing;
            this.routingbtn.toggled = !this.routingbtn.toggled;
        }
    }

    public void addsafe(int n) {
        int n2 = 0;
        n2 += n;
        int n3 = (int)this.random(1.0f, this.width - 1);
        int n4 = (int)this.random(1.0f, this.height - 1);
        boolean bl = true;
        int n5 = 0;
        while (n5 < this.vlist.size()) {
            if (finalsubmission.dist(n3, n4, ((Vehicle)this.vlist.get((int)n5)).x, ((Vehicle)this.vlist.get((int)n5)).y) < 50.0f) {
                bl = false;
            }
            ++n5;
        }
        if (bl) {
            this.vlist.add(new Vehicle(n3, n4, this.random((float)Math.PI * 2), 20.0f, 10.0f, this.random(5.0f), this.color(this.random())));
        } else if (n2 < 10) {
            this.addsafe(n2);
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#D4D0C8", "finalsubmission"});
    }

    class MovementThread
    implements Runnable {
        MovementThread() {
            finalsubmission.this.t = new Thread((Runnable)this, "Movement Thread");
            finalsubmission.this.t.start();
        }

        public void run() {
            try {
                while (true) {
                    int n = 0;
                    while (n < finalsubmission.this.vlist.size()) {
                        int n2 = 0;
                        while ((float)n2 < ((Vehicle)finalsubmission.this.vlist.get((int)n)).speed) {
                            if (finalsubmission.this.routing) {
                                ((Vehicle)finalsubmission.this.vlist.get(n)).route();
                            }
                            ((Vehicle)finalsubmission.this.vlist.get(n)).move();
                            if (finalsubmission.this.detectCollision) {
                                ((Vehicle)finalsubmission.this.vlist.get(n)).dc();
                            }
                            if (finalsubmission.this.avoidCollision) {
                                ((Vehicle)finalsubmission.this.vlist.get(n)).ac();
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    Thread.sleep((long)(1.0f / finalsubmission.this.frameRate * 1000.0f));
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Child interrupted.");
                System.out.println("Exiting child thread.");
                return;
            }
        }
    }

    class Road {
        ArrayList road = new ArrayList();
        ArrayList lane = new ArrayList();
        ArrayList lane2 = new ArrayList();

        Road() {
            this.road.add(this.lane);
            this.road.add(this.lane2);
            this.lane.add(new Point2D.Float(finalsubmission.this.width / 4, finalsubmission.this.height / 4));
            this.lane.add(new Point2D.Float((float)finalsubmission.this.width * 0.75f, finalsubmission.this.height / 4));
            this.lane.add(new Point2D.Float((float)finalsubmission.this.width * 0.8f, finalsubmission.this.height / 2));
            this.lane.add(new Point2D.Float((float)finalsubmission.this.width * 0.75f, (float)finalsubmission.this.height * 0.75f));
            this.lane.add(new Point2D.Float((float)finalsubmission.this.width * 0.25f, (float)finalsubmission.this.height * 0.75f));
            this.lane.add(new Point2D.Float((float)finalsubmission.this.width * 0.2f, finalsubmission.this.height / 2));
            this.lane2.add(new Point2D.Float((float)finalsubmission.this.width * 0.1f, (float)finalsubmission.this.height * 0.1f));
            this.lane2.add(new Point2D.Float((float)finalsubmission.this.width * 0.9f, (float)finalsubmission.this.height * 0.1f));
            this.lane2.add(new Point2D.Float((float)finalsubmission.this.width * 0.9f, (float)finalsubmission.this.height * 0.9f));
            this.lane2.add(new Point2D.Float((float)finalsubmission.this.width * 0.1f, (float)finalsubmission.this.height * 0.9f));
        }

        public void draw() {
            int n = 0;
            while (n < this.lane.size()) {
                finalsubmission.this.line((float)((Point2D)this.lane.get(n)).getX(), (float)((Point2D)this.lane.get(n)).getY(), (float)((Point2D)this.lane.get((n + 1) % this.lane.size())).getX(), (float)((Point2D)this.lane.get((n + 1) % this.lane.size())).getY());
                ++n;
            }
            n = 0;
            while (n < this.lane2.size()) {
                finalsubmission.this.line((float)((Point2D)this.lane2.get(n)).getX(), (float)((Point2D)this.lane2.get(n)).getY(), (float)((Point2D)this.lane2.get((n + 1) % this.lane2.size())).getX(), (float)((Point2D)this.lane2.get((n + 1) % this.lane2.size())).getY());
                ++n;
            }
        }
    }

    class Vehicle {
        float x;
        float y;
        float theta;
        float w;
        float l;
        float speed;
        int c;
        int vertices;
        int sensor_vertices;
        int[] x_before;
        int[] y_before;
        int[] x_after;
        int[] y_after;
        int[] xs_before;
        int[] ys_before;
        int[] xs_after;
        int[] ys_after;
        Polygon p_after;
        Polygon s_after;
        Rectangle bounds;
        Rectangle sbounds;
        PMatrix2D matrix;
        Point2D[] pastpath;
        ArrayList futurepath;

        Vehicle(float f, float f2, float f3, float f4, float f5, float f6, int n) {
            this.x = f;
            this.y = f2;
            this.theta = f3;
            this.w = f4;
            this.l = f5;
            this.speed = f6;
            this.c = n;
            this.vertices = 4;
            this.x_before = new int[this.vertices];
            this.y_before = new int[this.vertices];
            this.x_after = new int[this.vertices];
            this.y_after = new int[this.vertices];
            this.x_before[0] = (int)f4 / 2;
            this.x_before[1] = -((int)f4) / 2;
            this.x_before[2] = -((int)f4) / 2;
            this.x_before[3] = (int)f4 / 2;
            this.y_before[0] = (int)f5 / 2;
            this.y_before[1] = (int)f5 / 2;
            this.y_before[2] = -((int)f5) / 2;
            this.y_before[3] = -((int)f5) / 2;
            this.p_after = new Polygon();
            this.bounds = new Rectangle();
            this.sbounds = new Rectangle();
            this.matrix = new PMatrix2D();
            this.pastpath = new Point2D.Float[2];
            this.futurepath = new ArrayList();
            this.pastpath[0] = new Point2D.Float(f, f2);
            this.sensor_vertices = 8;
            this.xs_before = new int[this.sensor_vertices];
            this.ys_before = new int[this.sensor_vertices];
            this.xs_after = new int[this.sensor_vertices];
            this.ys_after = new int[this.sensor_vertices];
            this.xs_before[0] = (int)f4;
            this.ys_before[0] = 0;
            this.xs_before[1] = (int)(-f4);
            this.ys_before[1] = 0;
            this.xs_before[2] = 0;
            this.ys_before[2] = (int)f5;
            this.xs_before[3] = 0;
            this.ys_before[3] = (int)(-f5);
            this.xs_before[4] = (int)f4;
            this.ys_before[4] = (int)f5;
            this.xs_before[5] = (int)(-f4);
            this.ys_before[5] = (int)f5;
            this.xs_before[6] = (int)f4;
            this.ys_before[6] = (int)(-f5);
            this.xs_before[7] = (int)(-f4);
            this.ys_before[7] = (int)(-f5);
        }

        public void draw() {
            finalsubmission.this.pushMatrix();
            finalsubmission.this.translate(this.x, this.y);
            finalsubmission.this.rotate(this.theta);
            this.matrix = finalsubmission.this.getMatrix(this.matrix);
            finalsubmission.this.popMatrix();
            int n = 0;
            while (n < this.vertices) {
                this.x_after[n] = (int)this.matrix.multX(this.x_before[n], this.y_before[n]);
                this.y_after[n] = (int)this.matrix.multY(this.x_before[n], this.y_before[n]);
                ++n;
            }
            this.p_after = new Polygon(this.x_after, this.y_after, this.vertices);
            this.bounds = this.p_after.getBounds();
            finalsubmission.this.fill(this.c);
            finalsubmission.this.beginShape();
            n = 0;
            while (n < this.vertices) {
                finalsubmission.this.vertex(this.x_after[n], this.y_after[n]);
                ++n;
            }
            finalsubmission.this.endShape(2);
            n = 0;
            while (n < this.sensor_vertices) {
                this.xs_after[n] = (int)this.matrix.multX(this.xs_before[n], this.ys_before[n]);
                this.ys_after[n] = (int)this.matrix.multY(this.xs_before[n], this.ys_before[n]);
                ++n;
            }
            this.s_after = new Polygon(this.xs_after, this.ys_after, this.sensor_vertices);
            this.sbounds = this.s_after.getBounds();
            n = 0;
            while (n < this.sensor_vertices) {
                finalsubmission.this.ellipse(this.matrix.multX(this.xs_before[n], this.ys_before[n]), this.matrix.multY(this.xs_before[n], this.ys_before[n]), 3.0f, 3.0f);
                ++n;
            }
        }

        public void move() {
            this.x += finalsubmission.cos(this.theta);
            this.y += finalsubmission.sin(this.theta);
            if ((int)this.y == 0 || (int)this.y == finalsubmission.this.height) {
                this.theta = -this.theta;
            }
            if ((int)this.x == 0 || (int)this.x == finalsubmission.this.width) {
                this.theta = (float)Math.PI - this.theta;
            }
            this.theta %= (float)Math.PI * 2;
            if (finalsubmission.this.random(20.0f) < 1.0f) {
                this.pastpath[1] = this.pastpath[0];
                this.pastpath[0] = new Point2D.Float(this.x, this.y);
            }
            if (this.futurepath.size() != 0) {
                this.turn((Point2D)this.futurepath.get(0));
            }
            if (this.futurepath.size() != 0 && (int)finalsubmission.dist(this.x, this.y, (float)((Point2D)this.futurepath.get(0)).getX(), (float)((Point2D)this.futurepath.get(0)).getY()) == 0) {
                this.futurepath.remove(0);
            }
        }

        public void spline(Point2D point2D, Point2D point2D2) {
            Point2D[] point2DArray = new Point2D[5];
            float f = 0.0f;
            point2DArray[1] = this.pastpath[0];
            point2DArray[2] = new Point2D.Float(this.x, this.y);
            point2DArray[3] = point2D;
            point2DArray[4] = point2D2;
            int n = (int)finalsubmission.dist((float)point2DArray[2].getX(), (float)point2DArray[2].getY(), (float)point2DArray[3].getX(), (float)point2DArray[3].getY()) / 5;
            Point2D[] point2DArray2 = new Point2D[n];
            int n2 = 0;
            while (n2 < n) {
                point2DArray2[n2] = new Point2D.Float();
                point2DArray2[n2].setLocation(0.5 * ((-point2DArray[1].getX() + 3.0 * point2DArray[2].getX() - 3.0 * point2DArray[3].getX() + point2DArray[4].getX()) * (double)(f += 1.0f / (float)n) * (double)f * (double)f + (2.0 * point2DArray[1].getX() - 5.0 * point2DArray[2].getX() + 4.0 * point2DArray[3].getX() - point2DArray[4].getX()) * (double)f * (double)f + (-point2DArray[1].getX() + point2DArray[3].getX()) * (double)f + 2.0 * point2DArray[2].getX()), 0.5 * ((-point2DArray[1].getY() + 3.0 * point2DArray[2].getY() - 3.0 * point2DArray[3].getY() + point2DArray[4].getY()) * (double)f * (double)f * (double)f + (2.0 * point2DArray[1].getY() - 5.0 * point2DArray[2].getY() + 4.0 * point2DArray[3].getY() - point2DArray[4].getY()) * (double)f * (double)f + (-point2DArray[1].getY() + point2DArray[3].getY()) * (double)f + 2.0 * point2DArray[2].getY()));
                finalsubmission.this.point((float)point2DArray2[n2].getX(), (float)point2DArray2[n2].getY());
                this.futurepath.add(point2DArray2[n2]);
                ++n2;
            }
            this.futurepath.add(point2D);
            this.futurepath.add(point2D2);
        }

        public void turn(Point2D point2D) {
            PVector pVector = new PVector((float)point2D.getX() - this.x, (float)point2D.getY() - this.y);
            PVector pVector2 = new PVector(1.0f, 0.0f);
            this.theta = point2D.getY() > (double)this.y ? PVector.angleBetween(pVector, pVector2) : -PVector.angleBetween(pVector, pVector2);
        }

        public void ac() {
            Vehicle vehicle = this;
            int n = 0;
            while (n < finalsubmission.this.vlist.size()) {
                Vehicle vehicle2 = (Vehicle)finalsubmission.this.vlist.get(n);
                if (vehicle != vehicle2 && vehicle2.sbounds.intersects(vehicle.sbounds) && vehicle.s_after.contains(vehicle2.xs_after[0], vehicle2.ys_after[0])) {
                    vehicle2.speed = vehicle.speed = vehicle2.speed;
                }
                if (vehicle.sbounds.intersects(vehicle2.sbounds) && vehicle2.s_after.contains(vehicle.xs_after[1], vehicle.ys_after[1])) {
                    vehicle2.speed = vehicle.speed = vehicle2.speed;
                }
                ++n;
            }
        }

        public void network() {
        }

        public void route() {
            int n = 0;
            while (n < finalsubmission.this.r.lane.size()) {
                if ((int)finalsubmission.dist(this.x, this.y, (float)((Point2D)finalsubmission.this.r.lane.get(n)).getX(), (float)((Point2D)finalsubmission.this.r.lane.get(n)).getY()) == 0) {
                    this.turn((Point2D)finalsubmission.this.r.lane.get((n + 1) % finalsubmission.this.r.lane.size()));
                }
                ++n;
            }
            n = 0;
            while (n < finalsubmission.this.r.lane2.size()) {
                if ((int)finalsubmission.dist(this.x, this.y, (float)((Point2D)finalsubmission.this.r.lane2.get(n)).getX(), (float)((Point2D)finalsubmission.this.r.lane2.get(n)).getY()) == 0) {
                    this.turn((Point2D)finalsubmission.this.r.lane2.get((n + 1) % finalsubmission.this.r.lane2.size()));
                }
                ++n;
            }
        }

        public void dc() {
            Vehicle vehicle = this;
            int n = 0;
            while (n < finalsubmission.this.vlist.size()) {
                Vehicle vehicle2 = (Vehicle)finalsubmission.this.vlist.get(n);
                if (vehicle != vehicle2 && vehicle2.bounds.intersects(vehicle.bounds)) {
                    int n2 = 0;
                    while (n2 < vehicle.vertices) {
                        if (vehicle.p_after.contains(vehicle2.x_after[n2], vehicle2.y_after[n2])) {
                            vehicle2.speed = 0.0f;
                            vehicle.speed = 0.0f;
                            finalsubmission.this.console.add(new String(String.valueOf(finalsubmission.this.millis()) + " s " + vehicle.hashCode() + " has collided with " + vehicle2.hashCode()));
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    abstract class button {
        int unselected;
        int selected;
        int txtcolor;
        String textstring;
        float x;
        float y;
        float w;
        float h;
        Rectangle rec;

        button() {
            this.unselected = finalsubmission.this.color(125);
            this.selected = finalsubmission.this.color(-5111802);
            this.txtcolor = finalsubmission.this.color(255);
            this.textstring = "";
        }
    }

    class regbutton
    extends button {
        regbutton(String string, float f, float f2, float f3, float f4) {
            this.textstring = string;
            this.x = f;
            this.y = f2;
            this.w = f3;
            this.h = f4;
            if (f3 < (float)(string.length() * 6)) {
                this.w = string.length() * 6;
            }
            this.rec = new Rectangle(finalsubmission.round(f - this.w / 2.0f), finalsubmission.round(f2 - f4 / 2.0f), finalsubmission.round(this.w), finalsubmission.round(f4));
        }

        public void draw() {
            finalsubmission.this.rectMode(3);
            finalsubmission.this.fill(this.unselected);
            if (this.rec.contains(finalsubmission.this.mouseX, finalsubmission.this.mouseY)) {
                finalsubmission.this.fill(this.selected);
            }
            finalsubmission.this.rect(this.x, this.y, this.w, this.h);
            finalsubmission.this.fill(this.txtcolor);
            finalsubmission.this.text(this.textstring, this.x, this.y);
        }
    }

    class togglebutton
    extends button {
        boolean toggled = false;
        int toggledcolor;

        togglebutton(String string, float f, float f2, float f3, float f4, boolean bl) {
            this.toggledcolor = finalsubmission.this.color(-4229632);
            this.textstring = string;
            this.x = f;
            this.y = f2;
            this.w = f3;
            this.h = f4;
            this.toggled = bl;
            if (f3 < (float)(string.length() * 6)) {
                this.w = string.length() * 6;
            }
            this.rec = new Rectangle(finalsubmission.round(f - this.w / 2.0f), finalsubmission.round(f2 - f4 / 2.0f), finalsubmission.round(this.w), finalsubmission.round(f4));
        }

        public void draw() {
            finalsubmission.this.rectMode(3);
            finalsubmission.this.fill(this.unselected);
            if (this.rec.contains(finalsubmission.this.mouseX, finalsubmission.this.mouseY)) {
                finalsubmission.this.fill(this.selected);
            }
            if (this.toggled) {
                finalsubmission.this.fill(this.toggledcolor);
            }
            finalsubmission.this.rect(this.x, this.y, this.w, this.h);
            finalsubmission.this.fill(this.txtcolor);
            finalsubmission.this.text(this.textstring, this.x, this.y);
        }
    }
}

