//Campbell, Jesse
//CIS 288-001 PA 4

package d_2s_cellular_automata;

import java.awt.*;
import java.awt.event.*;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.JButton;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import java.util.Random;
import javax.swing.JSpinner;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.util.Random;

public class MainFrame extends JFrame {
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JToolBar jToolBar = new JToolBar();
    ImageIcon image_play = new ImageIcon(d_2s_cellular_automata.MainFrame.class.
                                         getResource("runstop.png"));
    ImageIcon image_1step = new ImageIcon(d_2s_cellular_automata.MainFrame.class.
                                          getResource("1step.png"));
    ImageIcon image_reset = new ImageIcon(d_2s_cellular_automata.MainFrame.class.
                                          getResource("reset.png"));
    ImageIcon image_stop = new ImageIcon(d_2s_cellular_automata.MainFrame.class.
                                          getResource("stop.png"));
    JLabel statusBar = new JLabel();
    JButton jButton5 = new JButton();
    JButton jButton6 = new JButton();
    JToggleButton jRunStopBtn = new JToggleButton();
    int width = 600, height=600, rect=3;
    Timer timer = new Timer(50, null);
    CA_1D2S ca = new CA_1D2S(width/rect + width%rect - 30/rect - 30%rect);
    int timeStep = 0;
    JPanel viewPane = new JPanel();
    SpinnerModel model = new SpinnerNumberModel(30, 0, 255, 1);
    JSpinner jSpinner1 = new JSpinner();
    JLabel jLabel1 = new JLabel();
    JCheckBox jCheckBox1 = new JCheckBox();
    JLabel jLabel3 = new JLabel();
    Random gen = new Random();
    JSlider jSlider2 = new JSlider(1,9,rect);
    JButton jButton1 = new JButton();
    TitledBorder titledBorder1 = new TitledBorder("");
    Test_CA_1D2S test = new Test_CA_1D2S();
    Test_CA_1D2S_Symmetry symmetrytest = new Test_CA_1D2S_Symmetry();

    public MainFrame() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(borderLayout1);

        setSize(new Dimension(width, height));
        setTitle("CS 288 - 1D 2S Cellular Automata (Enhanced)");
        statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        statusBar.setText(" ");
        jMenuFile.setText("File");
        jMenuFileExit.setText("Exit");
        jMenuFileExit.addActionListener(new
                                        MainFrame_jMenuFileExit_ActionAdapter(this));
        jMenuHelp.setText("Help");
        jMenuHelpAbout.setText("About");

        jButton5.setIcon(image_1step);
        jButton5.setText("Single Step");
        jButton5.addActionListener(new MainFrame_jButton5_actionAdapter(this));
        jButton5.setPreferredSize(new Dimension(90, 27));
        jButton6.setPreferredSize(new Dimension(90, 27));
        jButton6.setIcon(image_reset);
        jButton6.setText("Reset");
        jButton6.addActionListener(new MainFrame_jButton6_actionAdapter(this));
        jRunStopBtn.setMinimumSize(new Dimension(90, 27));
        jRunStopBtn.setPreferredSize(new Dimension(90, 27));
        jRunStopBtn.setIcon(image_play);
        jRunStopBtn.setPressedIcon(image_play);
        jRunStopBtn.setSelected(false);
        jRunStopBtn.setSelectedIcon(new ImageIcon(MainFrame.class.
                getResource("stop.png")));
        jRunStopBtn.setText("Start");
        jRunStopBtn.addActionListener(new
                                         MainFrame_jRunStopBtn_actionAdapter(this));
        viewPane.setBackground(Color.white);
        viewPane.setBorder(BorderFactory.createLineBorder(Color.black));
        jSpinner1.setMaximumSize(new Dimension(50, 50));
        jSpinner1.addMouseWheelListener(new
                                        MainFrame_jSpinner1_mouseWheelAdapter(this));
        jSpinner1.addChangeListener(new MainFrame_jSpinner1_changeAdapter(this));
        jLabel1.setText("  Rule: ");
        jCheckBox1.setText("Use Colors");
        jCheckBox1.addChangeListener(new MainFrame_jCheckBox1_changeAdapter(this));
        jCheckBox1.addActionListener(new MainFrame_jCheckBox1_actionAdapter(this));
        jLabel3.setText("     ");
        jSlider2.setMaximumSize(new Dimension(75, 24));
        jSlider2.setPreferredSize(new Dimension(50, 24));
        jSlider2.setToolTipText("Use Mouse Wheel");
        jSlider2.addMouseWheelListener(new MainFrame_jSlider2_mouseWheelAdapter(this));
        jSlider2.addChangeListener(new MainFrame_jSlider2_changeAdapter(this));
        jSlider2.setMajorTickSpacing(2);
        jSlider2.setMinorTickSpacing(1);
        jSlider2.setPaintTicks(true);
        jButton1.setBorder(null);
        jButton1.setText("   Cell Size: ");
        jMenuBar1.add(jMenuFile);
        jMenuFile.add(jMenuFileExit);
        jMenuBar1.add(jMenuHelp);
        setJMenuBar(jMenuBar1);
        jMenuHelp.add(jMenuHelpAbout);
        jToolBar.add(jRunStopBtn);
        jToolBar.add(jButton5);
        jToolBar.add(jButton6);
        jToolBar.add(jButton1);
        jToolBar.add(jSlider2);
        jToolBar.add(jLabel1);
        jToolBar.add(jSpinner1);
        jToolBar.add(jLabel3);
        jToolBar.add(jCheckBox1);
        contentPane.add(statusBar, BorderLayout.SOUTH);
        contentPane.add(viewPane, java.awt.BorderLayout.CENTER);
        contentPane.add(jToolBar, java.awt.BorderLayout.NORTH);
        timer.addActionListener(new MainFrame_Timer_actionAdapter(this));
        //ca.Rule(90);
        jSpinner1.setValue(new Integer(ca.Rule()));
        test.RunTest();
        symmetrytest.RunTest();
    }

    /**
     * File | Exit action performed.
     *
     * @param actionEvent ActionEvent
     */
    void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    /**
     * Help | About action performed.
     *
     * @param actionEvent ActionEvent
     */
    void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        MainFrame_AboutBox dlg = new MainFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x,
                        (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.show();
    }

    public void jButton4_actionPerformed(ActionEvent e) {

    }

    public void jButton5_actionPerformed(ActionEvent e) {
        if (jRunStopBtn.isSelected()) {
            jRunStopBtn.doClick();
        }
        timerEvent(e);
    }

    public void jButton6_actionPerformed(ActionEvent e) {
        clear();
        ca.Reset();
        viewPane.repaint();
        timeStep = 0;
        if (jRunStopBtn.isSelected()) {
            timer.start();
        }
    }

    public void jRunStopBtn_actionPerformed(ActionEvent e) {
        if (timer.isRunning()){
            timer.stop();
            ca.Reset();
        }
        else
        if (jRunStopBtn.isSelected()){
            timer.start();
        }
        if (jRunStopBtn.getText() == "Start")
            jRunStopBtn.setText("Stop");
        else if (jRunStopBtn.getText() == "Stop")
            jRunStopBtn.setText("Start");
        if (jRunStopBtn.isSelected())
            jRunStopBtn.setText("Stop");
    }

    public void timerEvent(ActionEvent e) {
        ShowCurrentRow(ca.GetCurrentRow(), timeStep);
        ca.TimeStep();
        timeStep++;

        if (timeStep > ((float)viewPane.getHeight()/(float)rect - (30/(float)rect))) {
            timeStep = 0;
            timer.stop();
            ca.Reset();
        }
        if (timeStep != 0)
        statusBar.setText("Timer step: " + timeStep);
    }

    public void clear() {
        Graphics g = viewPane.getGraphics();
        g.setColor(viewPane.getBackground());
        g.fillRect(0, 0, viewPane.getWidth(), viewPane.getHeight());
    }

    public void ShowCurrentRow(byte[] row, int time) {
        Graphics g = viewPane.getGraphics();

        for (int i = 0; i < ca.GetRowSize(); i++) {
            if (jCheckBox1.isSelected()){
                Color c = new Color(gen.nextInt(255),gen.nextInt(255),gen.nextInt(255));
                g.setColor(c);
            }
        else {
            g.setColor(Color.BLACK);
        }
            if (row[i] == 1)
            g.fillRect(10+rect*i, 10+rect*timeStep, rect, rect);
        }
    }

    public void jSpinner1_stateChanged(ChangeEvent e) {
        Object value = jSpinner1.getValue();
        int intvalue = ((Integer)value).intValue();

        if (intvalue > 255){
            value = new Integer(255);
            jSpinner1.setValue(value);
        }

        else if (intvalue < 0 ){
            value = new Integer(0);
            jSpinner1.setValue(value);
        }
        ca.Rule(((Integer)value).intValue());
    }

    public void jCheckBox1_actionPerformed(ActionEvent e) {
    }

    public void jCheckBox1_stateChanged(ChangeEvent e) {
        timer.stop();
        ca.Reset();
        clear();
        timeStep=0;
        if (viewPane.getBackground() == Color.WHITE)
            viewPane.setBackground(Color.BLACK);
        else if (viewPane.getBackground() == Color.BLACK)
                viewPane.setBackground(Color.WHITE);
        if(jRunStopBtn.isSelected())
        timer.start();
    }

    public void jSlider2_stateChanged(ChangeEvent e) {
        rect = jSlider2.getValue();
        timer.stop();
        int size = Math.round((float)width/(float)rect - (float)30/(float)rect);
        ca = new CA_1D2S(size);
        jSpinner1_stateChanged(e);
        clear();
        timeStep = 0;
        if (jRunStopBtn.isSelected())
            timer.start();
        viewPane.repaint();
    }

    public void jSlider2_mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() > 0)
            if (jSlider2.getValue() > jSlider2.getMinimum())
                jSlider2.setValue((jSlider2.getValue())-1);
        if (e.getWheelRotation() < 0)
            if (jSlider2.getValue() < jSlider2.getMaximum())
                jSlider2.setValue((jSlider2.getValue())+1);
    }

    public void jSpinner1_mouseWheelMoved(MouseWheelEvent e) {
        Object value = jSpinner1.getValue();
        int intvalue = ((Integer)value).intValue();
            if (e.getWheelRotation() < 0)
                    value = new Integer(intvalue + 1);
            if (e.getWheelRotation() > 0)
                    value = new Integer(intvalue - 1);
            jSpinner1.setValue(value);
     }
}


class MainFrame_jSlider2_changeAdapter implements ChangeListener {
    private MainFrame adaptee;
    MainFrame_jSlider2_changeAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void stateChanged(ChangeEvent e) {
        adaptee.jSlider2_stateChanged(e);
    }
}


class MainFrame_jSlider2_mouseWheelAdapter implements MouseWheelListener {
    private MainFrame adaptee;
    MainFrame_jSlider2_mouseWheelAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        adaptee.jSlider2_mouseWheelMoved(e);
    }
}


class MainFrame_jCheckBox1_actionAdapter implements ActionListener {
    private MainFrame adaptee;
    MainFrame_jCheckBox1_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBox1_actionPerformed(e);
    }
}


class MainFrame_jCheckBox1_changeAdapter implements ChangeListener {
    private MainFrame adaptee;
    MainFrame_jCheckBox1_changeAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void stateChanged(ChangeEvent e) {
        adaptee.jCheckBox1_stateChanged(e);
    }
}


class MainFrame_jSpinner1_changeAdapter implements ChangeListener {
    private MainFrame adaptee;
    MainFrame_jSpinner1_changeAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void stateChanged(ChangeEvent e) {
        adaptee.jSpinner1_stateChanged(e);
    }
}


class MainFrame_jSpinner1_mouseWheelAdapter implements MouseWheelListener {
    private MainFrame adaptee;
    MainFrame_jSpinner1_mouseWheelAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        adaptee.jSpinner1_mouseWheelMoved(e);
    }
}


class MainFrame_Timer_actionAdapter implements ActionListener {
    MainFrame adaptee;
    MainFrame_Timer_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        adaptee.timerEvent(actionEvent);
    }
}


class MainFrame_jRunStopBtn_actionAdapter implements ActionListener {
    private MainFrame adaptee;
    MainFrame_jRunStopBtn_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jRunStopBtn_actionPerformed(e);
    }
}


class MainFrame_jButton6_actionAdapter implements ActionListener {
    private MainFrame adaptee;
    MainFrame_jButton6_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButton6_actionPerformed(e);
    }
}


class MainFrame_jButton5_actionAdapter implements ActionListener {
    private MainFrame adaptee;
    MainFrame_jButton5_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButton5_actionPerformed(e);
    }
}

class MainFrame_jButton4_actionAdapter implements ActionListener {
    private MainFrame adaptee;
    MainFrame_jButton4_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButton4_actionPerformed(e);
    }
}


class MainFrame_jMenuFileExit_ActionAdapter implements ActionListener {
    MainFrame adaptee;

    MainFrame_jMenuFileExit_ActionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        adaptee.jMenuFileExit_actionPerformed(actionEvent);
    }
}
